

<?php $__env->startSection('title', 'Login - Beautez Telehealth'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-500 to-blue-700">
    <div class="max-w-md w-full bg-white rounded-lg shadow-xl p-8">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-gray-800">Beautez Telehealth</h1>
            <p class="text-gray-600 mt-2">Sign in to your account</p>
        </div>

        <form method="POST" action="<?php echo e(route('login')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-4">
                <label for="email" class="block text-gray-700 text-sm font-bold mb-2">
                    Email Address
                </label>
                <input type="email" 
                       id="email" 
                       name="email" 
                       value="<?php echo e(old('email')); ?>"
                       required 
                       autofocus
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div class="mb-6">
                <label for="password" class="block text-gray-700 text-sm font-bold mb-2">
                    Password
                </label>
                <input type="password" 
                       id="password" 
                       name="password" 
                       required
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <button type="submit" 
                    class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                Sign In
            </button>
        </form>

        <div class="mt-6 text-center">
            <p class="text-sm text-gray-600 mb-4">
                Don't have an account? 
                <a href="<?php echo e(route('doctor.register')); ?>" class="text-blue-600 hover:text-blue-800 font-semibold">
                    Register as Doctor
                </a>
                <?php if(\App\Models\Setting::get('patient_registration_enabled', false)): ?>
                    <span class="mx-2">|</span>
                    <a href="<?php echo e(route('patient.register')); ?>" class="text-blue-600 hover:text-blue-800 font-semibold">
                        Register as Patient
                    </a>
                <?php endif; ?>
            </p>
            <div class="text-sm text-gray-600">
                <p>Default credentials:</p>
                <p class="mt-2">Admin: admin@beautez.com / password</p>
                <p>Doctor: doctor@beautez.com / password</p>
                <p>Pharmacist: pharmacist@beautez.com / password</p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/auth/login.blade.php ENDPATH**/ ?>